VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "cBall"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Public Body As cpBody, Shape As cpCircleShape

Public Sub Construct(ByVal X As Double, ByVal Y As Double, ByVal Radius As Double, ByVal Mass As Double)

  Set Body = PhEngine.CreateBody(Mass, PhEngine.GetMomentForCircle(Mass, 0#, Radius, 0, 0))
    Body.V_Limit = 120 'since the Demo is "self-accelerating" (having a Damping-Value > 1 on the PhEngine)...
    Body.W_Limit = 2 '... we need to ensure, that our non-static Bodies are provided with some limits
  PhEngine.Space.AddBody Body, X, Y
  
  Set Shape = Body.CreateCircleShape(Radius, 0, 0)
  
  PhEngine.Space.AddShape Shape, 0.3, 0.1
  
  'now - if it does not exists yet in our global Imagelist - we add a small sprite here from an Alpha-Png-resource
  If Not Cairo.ImageList.Exists("Waterball") Then Cairo.ImageList.AddImage "Waterball", App.Path & "\Waterball.png", 2 * Radius + 0.6, 2 * Radius + 0.6
End Sub

Public Sub Draw(CC As cCairoContext)
Static SrfPat As cCairoPattern

  CC.Save
    CC.TranslateDrawings Shape.tC_X, Shape.tC_Y 'translate the CC to the current center of of the Shape
    CC.RotateDrawings Cairo.CalcArc(Body.Rot_Y, Body.Rot_X) 'now rotate the Coord-System (according to the current Infos in our Body)
    
    'Cairo.ImageList(SomeKey) delivers a Surface-Object (in our case our stored Sprite)
    'and to be able to shift the center of such a Surface-Object (just before we render it below),
    'we need to wrap it beforehand in some lightweight-container-Object, which allows transforms
    'And such a wrapper-object is the cCairoPattern, which can be derived from any Surface by:
    Set SrfPat = Cairo.ImageList("Waterball").CreateSurfacePattern

    'now the just mentioned shift "within the Sprite-Pattern", to finally bring
    'the pattern-wrapped Sprite-center into sync with our current center of the CC
    Set SrfPat.Matrix = SrfPat.Matrix.TranslateCoords(SrfPat.Surface.Width / 2, SrfPat.Surface.Height / 2)
      CC.SetSourcePattern SrfPat
    CC.Paint

  CC.Restore
End Sub

